/*
 * Decompiled with CFR 0.152.
 */
package net.angelluislopez.crossownership;

import net.angelluislopez.crossownership.TotalSimu;

class AJ
extends TotalSimu {
    private double Fbeta = 0.5;

    AJ(double N, double Beta2, double B, double Gamma2) {
        super(N, Beta2, B, Gamma2);
        this.a = 700.0;
        this.C = 500.0;
    }

    @Override
    void setFbeta(double aFbeta) {
        this.Fbeta = aFbeta;
    }

    @Override
    double getFbeta() {
        return this.Fbeta;
    }

    void setA(double aA) {
        this.a = aA;
    }

    void setC(double aC) {
        this.C = aC;
    }

    double getA() {
        return this.a;
    }

    double getC() {
        return this.C;
    }

    @Override
    public double[] getLTSbeta() {
        double[] LTSbeta = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double Denominator;
            double Numerator = ((this.getN() + 2.0) * (this.getN() - 1.0) * vBetas[i] - (this.getN() - 2.0)) * vBetas[i] - this.getB() * this.getGamma();
            LTSbeta[i] = Numerator / (Denominator = (this.getN() - 1.0) * (2.0 * (vBetas[i] - 1.0) * vBetas[i] + this.getB() * this.getGamma())) < 0.0 ? 0.0 : (Numerator / Denominator > 1.0 ? 1.0 : Numerator / Denominator);
        }
        return LTSbeta;
    }

    @Override
    public double[] getMhhiTSbeta() {
        double[] lambdaTSbeta = new double[nsteps + 1];
        lambdaTSbeta = this.getLTSbeta();
        double[] mhhi = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            mhhi[i] = (1.0 + lambdaTSbeta[i] * (this.getN() - 1.0)) / this.getN();
        }
        return mhhi;
    }

    @Override
    public double[] getLCSbeta() {
        double[] LCSbeta = new double[nsteps + 1];
        double betaprime = this.getBetaprime();
        for (int i = 1; i <= nsteps; ++i) {
            LCSbeta[i] = vBetas[i] <= betaprime ? 0.0 : 1.0;
        }
        return LCSbeta;
    }

    @Override
    public double[] getMhhiCSbeta() {
        double[] mhhi = new double[nsteps + 1];
        double[] lambdacsbeta = new double[nsteps + 1];
        lambdacsbeta = this.getLCSbeta();
        for (int i = 0; i <= nsteps; ++i) {
            mhhi[i] = (1.0 + lambdacsbeta[i] * (this.getN() - 1.0)) / this.getN();
        }
        return mhhi;
    }

    @Override
    public double getBetaupperbar() {
        double Denominator;
        double value = -1.0;
        double A1 = Math.pow(this.getN() - 2.0, 2.0);
        double Numerator = this.getN() - 2.0 + Math.sqrt(A1 + 4.0 * this.getB() * this.getGamma() * (this.getN() + 2.0) * (this.getN() - 1.0));
        double betaupperbar = Numerator / (Denominator = 2.0 * (this.getN() + 2.0) * (this.getN() - 1.0));
        if (betaupperbar >= 0.0) {
            value = betaupperbar;
        }
        return value;
    }

    @Override
    public double getBetaprime() {
        double Denominator;
        double value = -1.0;
        double Numerator = -1.0 + Math.sqrt(1.0 + 4.0 * this.getB() * this.getGamma() * (this.getN() - 1.0));
        double betaprime = Numerator / (Denominator = 2.0 * (this.getN() - 1.0));
        if (betaprime >= 0.0) {
            value = betaprime;
        }
        return value;
    }

    @Override
    double[] getWlambda() {
        double[] Wlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            double q = this.getGamma() * (this.a - this.C) / (this.getB() * this.getGamma() * (Lambda + this.getN()) - B * tau);
            double Q = this.getN() * q;
            double x = tau * (this.a - this.C) / (this.getB() * this.getGamma() * (Lambda + this.getN()) - B * tau);
            double cs = this.a * Q - this.getB() * Q * Q / 2.0;
            double c = this.C - B * x;
            Wlambda[i] = cs - this.getN() * c * q - this.getN() * this.getGamma() * x * x / 2.0;
        }
        return Wlambda;
    }

    @Override
    double[] getCSlambda() {
        double[] CSlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double ncs;
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            double q = this.getGamma() * (this.a - this.C) / (this.getB() * this.getGamma() * (Lambda + this.getN()) - B * tau);
            double Q = this.getN() * q;
            CSlambda[i] = ncs = this.a * Q - this.getB() * Q * Q / 2.0 - (this.a - this.getB() * Q) * Q;
        }
        return CSlambda;
    }

    @Override
    double[] getEqlambda() {
        double[] Eqlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double q;
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            Eqlambda[i] = q = this.getGamma() * (this.a - this.C) / (this.getB() * this.getGamma() * (Lambda + this.getN()) - B * tau);
        }
        return Eqlambda;
    }

    @Override
    double[] getExlambda() {
        double[] Exlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double x;
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            Exlambda[i] = x = tau * (this.a - this.C) / (this.getB() * this.getGamma() * (Lambda + this.getN()) - B * tau);
        }
        return Exlambda;
    }

    @Override
    double[] getEplambda() {
        double[] price = new double[nsteps + 1];
        double[] eqoutput = new double[nsteps + 1];
        eqoutput = this.getEqlambda();
        for (int i = 0; i <= nsteps; ++i) {
            price[i] = this.a - this.getB() * this.getN() * eqoutput[i];
        }
        return price;
    }

    @Override
    double[] getEcostlambda() {
        double[] cost = new double[nsteps + 1];
        double[] eqx = new double[nsteps + 1];
        eqx = this.getExlambda();
        for (int i = 0; i <= nsteps; ++i) {
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            cost[i] = this.C - B * eqx[i];
        }
        return cost;
    }

    @Override
    double[] getEprofitlambda() {
        double[] eqprice = new double[nsteps + 1];
        double[] eqoutput = new double[nsteps + 1];
        double[] eqx = new double[nsteps + 1];
        double[] ecost = new double[nsteps + 1];
        double[] profit = new double[nsteps + 1];
        eqoutput = this.getEqlambda();
        eqprice = this.getEplambda();
        eqx = this.getExlambda();
        ecost = this.getEcostlambda();
        for (int i = 0; i <= nsteps; ++i) {
            double invcost = this.getGamma() * eqx[i] * eqx[i] / 2.0;
            profit[i] = eqprice[i] * eqoutput[i] - ecost[i] * eqoutput[i] - invcost;
        }
        return profit;
    }
}

