/*
 * Decompiled with CFR 0.152.
 */
package net.angelluislopez.crossownership;

import net.angelluislopez.crossownership.TotalSimu;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.univariate.BrentOptimizer;
import org.apache.commons.math3.optim.univariate.MultiStartUnivariateOptimizer;
import org.apache.commons.math3.optim.univariate.SearchInterval;
import org.apache.commons.math3.optim.univariate.UnivariateObjectiveFunction;
import org.apache.commons.math3.optim.univariate.UnivariateOptimizer;
import org.apache.commons.math3.random.JDKRandomGenerator;

public class AJ2S
extends TotalSimu {
    JDKRandomGenerator g;
    private double Fbeta = 0.5;

    AJ2S(double N, double Beta2, double B, double Gamma2) {
        super(N, Beta2, B, Gamma2);
        this.a = 700.0;
        this.C = 500.0;
        this.g = new JDKRandomGenerator();
        this.g.setSeed(44428400075L);
    }

    @Override
    void setFbeta(double aFbeta) {
        this.Fbeta = aFbeta;
    }

    @Override
    double getFbeta() {
        return this.Fbeta;
    }

    void setA(double aA) {
        this.a = aA;
    }

    void setC(double aC) {
        this.C = aC;
    }

    double getA() {
        System.out.println(this.a + "\n");
        return this.a;
    }

    double getC() {
        return this.C;
    }

    @Override
    double[] getLTSbeta() {
        double[] LTSbeta = new double[nsteps + 1];
        twFunctionSolver ws = new twFunctionSolver();
        for (int i = 0; i <= nsteps; ++i) {
            ws.beta = vBetas[i];
            ws.compute();
            LTSbeta[i] = ws.optimal;
        }
        return LTSbeta;
    }

    @Override
    double[] getMhhiTSbeta() {
        double[] lambdaTSbeta = new double[nsteps + 1];
        lambdaTSbeta = this.getLTSbeta();
        double[] mhhi = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            mhhi[i] = (1.0 + lambdaTSbeta[i] * (this.getN() - 1.0)) / this.getN();
        }
        return mhhi;
    }

    @Override
    double[] getLCSbeta() {
        double[] LCSbeta = new double[nsteps + 1];
        csFunctionSolver cs = new csFunctionSolver();
        for (int i = 0; i <= nsteps; ++i) {
            cs.beta = vBetas[i];
            cs.compute();
            LCSbeta[i] = cs.optimal;
        }
        return LCSbeta;
    }

    @Override
    double[] getMhhiCSbeta() {
        double[] mhhi = new double[nsteps + 1];
        double[] lambdacsbeta = new double[nsteps + 1];
        lambdacsbeta = this.getLCSbeta();
        for (int i = 0; i <= nsteps; ++i) {
            mhhi[i] = (1.0 + lambdacsbeta[i] * (this.getN() - 1.0)) / this.getN();
        }
        return mhhi;
    }

    @Override
    double getBetaupperbar() {
        boolean flag = false;
        double[] lambdafctbeta = new double[nsteps + 1];
        double value = -1.0;
        lambdafctbeta = this.getLTSbeta();
        for (int i = 0; i <= nsteps; ++i) {
            if (!(lambdafctbeta[i] > 1.0E-6)) continue;
            flag = true;
            value = vBetas[i];
            break;
        }
        if (flag) {
            return value;
        }
        return -1.0;
    }

    @Override
    double getBetaprime() {
        boolean flag = false;
        double[] lambdafctbeta = new double[nsteps + 1];
        double value = -1.0;
        lambdafctbeta = this.getLCSbeta();
        for (int i = 0; i <= nsteps; ++i) {
            if (!(lambdafctbeta[i] > 1.0E-6)) continue;
            flag = true;
            value = vBetas[i];
            break;
        }
        if (flag) {
            return value;
        }
        return -1.0;
    }

    double[] getBetatildalambda() {
        double[] betatilda = new double[nsteps + 1];
        double[] lambdatsbeta = new double[nsteps + 1];
        lambdatsbeta = this.getLTSbeta();
        for (int i = 0; i <= nsteps; ++i) {
            betatilda[i] = 0.5 + lambdatsbeta[i] / 2.0;
        }
        return betatilda;
    }

    @Override
    double[] getWlambda() {
        double[] Wlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            double Deltat = (this.getGamma() * this.getB() * Math.pow(Lambda + this.getN(), 2.0) - B * ((this.getN() - 1.0) * Lambda * (1.0 + vLambdas[i] - 2.0 * this.Fbeta) + (Lambda + this.getN()) * tau)) / (Lambda + this.getN());
            double q = this.getGamma() * (this.a - this.C) / Deltat;
            double Q = this.getN() * q;
            double x = ((this.getN() - 1.0) * Lambda / (this.getN() + Lambda) * (1.0 + vLambdas[i] - 2.0 * this.Fbeta) + tau) * (this.a - this.C) / Deltat;
            double cs = this.a * Q - this.getB() * Q * Q / 2.0;
            double c = this.C - B * x;
            Wlambda[i] = cs - this.getN() * c * q - this.getN() * this.getGamma() * x * x / 2.0;
        }
        return Wlambda;
    }

    @Override
    double[] getCSlambda() {
        double[] CSlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double ncs;
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            double Deltat = (this.getGamma() * this.getB() * Math.pow(Lambda + this.getN(), 2.0) - B * ((this.getN() - 1.0) * Lambda * (1.0 + vLambdas[i] - 2.0 * this.Fbeta) + (Lambda + this.getN()) * tau)) / (Lambda + this.getN());
            double q = this.getGamma() * (this.a - this.C) / Deltat;
            double Q = this.getN() * q;
            CSlambda[i] = ncs = this.a * Q - this.getB() * Q * Q / 2.0 - (this.a - this.getB() * Q) * Q;
        }
        return CSlambda;
    }

    @Override
    double[] getEqlambda() {
        double[] Eqlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double q;
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            double Deltat = (this.getGamma() * this.getB() * Math.pow(Lambda + this.getN(), 2.0) - B * ((this.getN() - 1.0) * Lambda * (1.0 + vLambdas[i] - 2.0 * this.Fbeta) + (Lambda + this.getN()) * tau)) / (Lambda + this.getN());
            Eqlambda[i] = q = this.getGamma() * (this.a - this.C) / Deltat;
        }
        return Eqlambda;
    }

    @Override
    double[] getExlambda() {
        double[] Exlambda = new double[nsteps + 1];
        for (int i = 0; i <= nsteps; ++i) {
            double x;
            double Lambda = 1.0 + vLambdas[i] * (this.getN() - 1.0);
            double tau = 1.0 + vLambdas[i] * (this.getN() - 1.0) * this.Fbeta;
            double B = 1.0 + this.Fbeta * (this.getN() - 1.0);
            double Deltat = (this.getGamma() * this.getB() * Math.pow(Lambda + this.getN(), 2.0) - B * ((this.getN() - 1.0) * Lambda * (1.0 + vLambdas[i] - 2.0 * this.Fbeta) + (Lambda + this.getN()) * tau)) / (Lambda + this.getN());
            Exlambda[i] = x = ((this.getN() - 1.0) * Lambda / (this.getN() + Lambda) * (1.0 + vLambdas[i] - 2.0 * this.Fbeta) + tau) * (this.a - this.C) / Deltat;
        }
        return Exlambda;
    }

    @Override
    double[] getEplambda() {
        double[] price = new double[nsteps + 1];
        double[] eqoutput = new double[nsteps + 1];
        eqoutput = this.getEqlambda();
        for (int i = 0; i <= nsteps; ++i) {
            price[i] = this.a - this.getB() * this.getN() * eqoutput[i];
        }
        return price;
    }

    @Override
    double[] getEcostlambda() {
        double[] cost = new double[nsteps + 1];
        double[] eqx = new double[nsteps + 1];
        eqx = this.getExlambda();
        for (int i = 0; i <= nsteps; ++i) {
            double B = 1.0 + vBetas[i] * (this.getN() - 1.0);
            cost[i] = this.C - B * eqx[i];
        }
        return cost;
    }

    @Override
    double[] getEprofitlambda() {
        double[] eqprice = new double[nsteps + 1];
        double[] eqoutput = new double[nsteps + 1];
        double[] eqx = new double[nsteps + 1];
        double[] ecost = new double[nsteps + 1];
        double[] profit = new double[nsteps + 1];
        eqoutput = this.getEqlambda();
        eqprice = this.getEplambda();
        eqx = this.getExlambda();
        ecost = this.getEcostlambda();
        for (int i = 0; i <= nsteps; ++i) {
            double invcost = this.getGamma() * eqx[i] * eqx[i] / 2.0;
            profit[i] = eqprice[i] * eqoutput[i] - ecost[i] * eqoutput[i] - invcost;
        }
        return profit;
    }

    class csFunction
    implements UnivariateFunction {
        double beta;

        csFunction(double Beta2) {
            this.beta = Beta2;
        }

        @Override
        public double value(double lambda) {
            double Lambda = 1.0 + lambda * (AJ2S.this.getN() - 1.0);
            double tau = 1.0 + lambda * (AJ2S.this.getN() - 1.0) * this.beta;
            double B = 1.0 + this.beta * (AJ2S.this.getN() - 1.0);
            double Deltat = (AJ2S.this.getGamma() * AJ2S.this.getB() * Math.pow(Lambda + AJ2S.this.getN(), 2.0) - B * ((AJ2S.this.getN() - 1.0) * Lambda * (1.0 + lambda - 2.0 * this.beta) + (Lambda + AJ2S.this.getN()) * tau)) / (Lambda + AJ2S.this.getN());
            double q = AJ2S.this.getGamma() * (AJ2S.this.a - AJ2S.this.C) / Deltat;
            double Q = AJ2S.this.getN() * q;
            double cs = AJ2S.this.a * Q - AJ2S.this.getB() * Q * Q / 2.0;
            return cs;
        }
    }

    class csFunctionSolver {
        double beta;
        double optimal;
        UnivariateOptimizer underlying = new BrentOptimizer(1.11E-14, 1.11E-15);
        MultiStartUnivariateOptimizer optimizer;

        csFunctionSolver() {
            this.optimizer = new MultiStartUnivariateOptimizer(this.underlying, 5, AJ2S.this.g);
        }

        public void compute() {
            this.optimal = this.optimizer.optimize(new MaxEval(10000), new UnivariateObjectiveFunction(new csFunction(this.beta)), GoalType.MAXIMIZE, new SearchInterval(0.0, 1.0)).getPoint();
        }
    }

    class twFunction
    implements UnivariateFunction {
        double beta;

        twFunction(double Beta2) {
            this.beta = Beta2;
        }

        @Override
        public double value(double lambda) {
            double Lambda = 1.0 + lambda * (AJ2S.this.getN() - 1.0);
            double tau = 1.0 + lambda * (AJ2S.this.getN() - 1.0) * this.beta;
            double B = 1.0 + this.beta * (AJ2S.this.getN() - 1.0);
            double Deltat = (AJ2S.this.getGamma() * AJ2S.this.getB() * Math.pow(Lambda + AJ2S.this.getN(), 2.0) - B * ((AJ2S.this.getN() - 1.0) * Lambda * (1.0 + lambda - 2.0 * this.beta) + (Lambda + AJ2S.this.getN()) * tau)) / (Lambda + AJ2S.this.getN());
            double q = AJ2S.this.getGamma() * (AJ2S.this.a - AJ2S.this.C) / Deltat;
            double Q = AJ2S.this.getN() * q;
            double x = ((AJ2S.this.getN() - 1.0) * Lambda / (AJ2S.this.getN() + Lambda) * (1.0 + lambda - 2.0 * this.beta) + tau) * (AJ2S.this.a - AJ2S.this.C) / Deltat;
            double cs = AJ2S.this.a * Q - AJ2S.this.getB() * Q * Q / 2.0;
            double c = AJ2S.this.C - B * x;
            double w = cs - AJ2S.this.getN() * c * q - AJ2S.this.getN() * AJ2S.this.getGamma() * x * x / 2.0;
            return w;
        }
    }

    class twFunctionSolver {
        double beta;
        double optimal;
        UnivariateOptimizer underlying = new BrentOptimizer(1.11E-14, 1.11E-15);
        MultiStartUnivariateOptimizer optimizer;

        twFunctionSolver() {
            this.optimizer = new MultiStartUnivariateOptimizer(this.underlying, 5, AJ2S.this.g);
        }

        public void compute() {
            this.optimal = this.optimizer.optimize(new MaxEval(10000), new UnivariateObjectiveFunction(new twFunction(this.beta)), GoalType.MAXIMIZE, new SearchInterval(0.0, 1.0)).getPoint();
        }
    }
}

