/*
 * Decompiled with CFR 0.152.
 */
package net.angelluislopez.crossownership;

abstract class TotalSimu {
    double a;
    double C;
    double sigma;
    double kappa;
    double epsilon;
    double alpha;
    private double n;
    private double beta;
    private double b;
    private double gamma;
    double Fbeta;
    protected static double[] vBetas;
    protected static double[] vLambdas;
    protected static int nsteps;
    protected static final double REL = 1.11E-14;
    protected static final double ABS = 1.11E-15;
    protected static final int NSTARTS = 5;

    protected static void setNumberSteps(int n) {
        int i;
        nsteps = n;
        vBetas = new double[nsteps + 1];
        TotalSimu.vBetas[0] = 0.0;
        for (i = 1; i <= nsteps; ++i) {
            TotalSimu.vBetas[i] = vBetas[i - 1] + 1.0 / (double)nsteps;
        }
        vLambdas = new double[nsteps + 1];
        TotalSimu.vLambdas[0] = 0.0;
        for (i = 1; i <= nsteps; ++i) {
            TotalSimu.vLambdas[i] = vLambdas[i - 1] + 1.0 / (double)nsteps;
        }
    }

    public TotalSimu(double N) {
        this.n = N;
    }

    public TotalSimu(double N, double Beta2, double B, double Gamma2) {
        this.n = N;
        this.beta = Beta2;
        this.b = B;
        this.gamma = Gamma2;
    }

    abstract double[] getLTSbeta();

    abstract double[] getMhhiTSbeta();

    abstract double[] getLCSbeta();

    abstract double[] getMhhiCSbeta();

    abstract double[] getEqlambda();

    abstract double[] getExlambda();

    abstract double[] getEplambda();

    abstract double[] getEcostlambda();

    abstract double[] getEprofitlambda();

    abstract void setFbeta(double var1);

    abstract double getFbeta();

    abstract double[] getWlambda();

    abstract double[] getCSlambda();

    abstract double getBetaupperbar();

    abstract double getBetaprime();

    public double getN() {
        return this.n;
    }

    public double getB() {
        return this.b;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getEpsilon() {
        return 0.0;
    }

    public double getAlpha() {
        return 0.0;
    }

    public void setN(double aN) {
        this.n = aN;
    }

    public void setB(double aB) {
        this.b = aB;
    }

    public void setGamma(double aGamma) {
        this.gamma = aGamma;
    }

    public void setBeta(double aBeta) {
        this.beta = aBeta;
    }

    static {
        int i;
        nsteps = 50;
        vBetas = new double[nsteps + 1];
        TotalSimu.vBetas[0] = 0.0;
        for (i = 1; i <= nsteps; ++i) {
            TotalSimu.vBetas[i] = vBetas[i - 1] + 1.0 / (double)nsteps;
        }
        vLambdas = new double[nsteps + 1];
        TotalSimu.vLambdas[0] = 0.0;
        for (i = 1; i <= nsteps; ++i) {
            TotalSimu.vLambdas[i] = vLambdas[i - 1] + 1.0 / (double)nsteps;
        }
    }
}

